/**
 * RemoveNode Plugin for jsTree
 */
$.jstree.plugins.removenode = function(options, parent) {
    var removeIcon = $('<i>', {
        class: 'jstree-icon jstree-removenode-remove',
        attr:{
            role:'presentation',
            'title':Omeka.jsTranslate('Remove link'),
            'aria-label':Omeka.jsTranslate('Remove link')
        },
    });
    var undoIcon = $('<i>', {
        class: 'jstree-icon jstree-removenode-undo',
        attr:{
            role:'presentation',
            'title':Omeka.jsTranslate('Restore link'),
            'aria-label':Omeka.jsTranslate('Restore link')
        }
    });
    var toBeRemovedSpan = $('<span>', {
        class: 'jstree-removenode-toberemoved',
        style: 'display: none;'
    }).text(Omeka.jsTranslate('link to be removed'));
    this.bind = function() {
        parent.bind.call(this);
        this.element.on(
            'click.jstree',
            '.jstree-removenode-remove, .jstree-removenode-undo',
            $.proxy(function(e) {
                var icon = $(e.currentTarget);
                var node = icon.closest('.jstree-node');
                var nodeObj = this.get_node(node);
                icon.hide();
                if (icon.hasClass('jstree-removenode-remove')) {
                    // Handle node removal.
                    node.find('.jstree-anchor').children().hide();
                    node.find('.jstree-anchor').children('.jstree-removenode-toberemoved').show();
                    icon.siblings('.jstree-removenode-undo').show();
                    node.addClass('jstree-removenode-removed');
                    nodeObj.data.remove = true;
                    // Remove required flags else the browser will not submit.
                    var required = node.find(':input[required]');
                    required.attr('data-required', true);
                    required.prop('required', false);
                } else {
                    // Handle undo node removal.
                    node.find('.jstree-anchor').children(':not(.jstree-removenode-undo)').show();
                    node.find('.jstree-anchor').children('.jstree-removenode-toberemoved').hide();
                    icon.siblings('.jstree-removenode-remove').show();
                    node.removeClass('jstree-removenode-removed');
                    nodeObj.data.remove = false;
                    // Restore required flags.
                    var required = node.find(':input[data-required]');
                    required.removeAttr('data-required');
                    required.prop('required', true);
                }
            }, this)
        );
    };
    this.redraw_node = function(node, deep, is_callback, force_render) {
        node = parent.redraw_node.apply(this, arguments);
        if (node) {
            // Add remove/undo icons to every node.
            var nodeJq = $(node);
            var anchor = nodeJq.children('.jstree-anchor');
            var removeIconClone = removeIcon.clone();
            var undoIconClone = undoIcon.clone();
            anchor.append(removeIconClone);
            anchor.append(undoIconClone);
            anchor.append(toBeRemovedSpan.clone());

            // Carry over the removed/not-removed state
            var data = this.get_node(node).data;
            if (data.remove === 'undefined' || data.remove) {
                removeIconClone.hide();
                nodeJq.addClass('jstree-removenode-removed');
            } else {
                undoIconClone.hide();
                nodeJq.removeClass('jstree-removenode-removed');
            }
        }
        return node;
    };
};

/**
 * PrivateStatus plugin for jsTree
 */

$.jstree.plugins.privateStatus = function(options, parent) {
    var privateIcon = $('<i>', {
        class: 'jstree-icon jstree-private',
        attr:{
            'role':'presentation',
            'aria-label':Omeka.jsTranslate('Private'),
            'title': Omeka.jsTranslate('Private')},
    });
    this.redraw_node = function(node, deep, is_callback, force_render) {
        node = parent.redraw_node.apply(this, arguments);
        if (node) {
            var nodeObj = this.get_node(node);
            var nodeIsPublic = nodeObj.data.data.is_public;
            if (nodeIsPublic == 0) {
                var nodeJq = $(node);
                var anchor = nodeJq.children('.jstree-anchor');
                anchor.append(privateIcon.clone());
            }
        }
        return node;
    };
}

/**
 * EditLink plugin for jsTree
 */
$.jstree.plugins.editlink = function(options, parent) {
    var container = $('<div>', {
        class: 'jstree-editlink-container'
    });
    var editIcon = $('<i>', {
        class: 'jstree-icon jstree-editlink-edit',
        attr:{
            role:'presentation',
            'title':Omeka.jsTranslate('Edit link'),
            'aria-label':Omeka.jsTranslate('Edit link')
        },
    });
    // Toggle edit link container.
    this.toggleLinkEdit = function(node) {
        var container = node.children('.jstree-editlink-container');
        node.toggleClass('jstree-editlink-editmode');
        container.slideToggle();
    };
    this.bind = function() {
        parent.bind.call(this);
        // Toggle edit link container when icon is clicked.
        this.element.on(
            'click.jstree',
            '.jstree-editlink-edit',
            $.proxy(function(e) {
                this.toggleLinkEdit($(e.currentTarget).closest('.jstree-node'));
            }, this)
        );
        // Add a custom page link to the navigation tree.
        $('#nav-custom-links').on(
            'click',
            'button.option',
            $.proxy(function(e) {
                var link = $(e.currentTarget);
                var nodeId = this.create_node('#', {
                    text: link.text(),
                    data: {
                        type: link.data('type'),
                        data: {}
                    }
                });
                this.toggleLinkEdit($('#' + nodeId));
            }, this)
        );
        // Add a site page link to the navigation tree.
        $('#nav-page-links').on(
            'click',
            '.nav-page-link',
            $.proxy(function(e) {
                var link = $(e.currentTarget);
                var nodeId = this.create_node('#', {
                    text: link.data('label'),
                    data: {
                        type: link.data('type'),
                        data: {
                            id: link.data('id'),
                            'is_public': link.data('is_public')
                        }
                    }
                });
                // There cannot be duplicate page links in navigation. Remove
                // page links from the available list after they are added.
                link.hide();
                var pageLinks = $(e.delegateTarget);
                if (!pageLinks.children('.nav-page-link').filter(':visible').length) {
                    pageLinks.siblings('.page-selector-filter').hide();
                    pageLinks.after('<p>' + Omeka.jsTranslate('There are no available pages.') + '</p>');
                }
                this.toggleLinkEdit($('#' + nodeId));
            }, this)
        );
        // Prepare the navigation tree data for submission.
        $('#site-form').on(
            'submit',
            $.proxy(function(e) {
                var instance = this;
                $('#nav-tree :input[data-name]').each(function(index, element) {
                    var nodeObj = instance.get_node(element);
                    var element = $(element);
                    nodeObj.data['data'][element.data('name')] = element.val()
                });
                $('<input>', {
                    'type': 'hidden',
                    'name': 'jstree',
                    'val': JSON.stringify(instance.get_json())
                }).appendTo('#site-form');
            }, this)
        );

        // Open closed nodes if their inputs have validation errors
        document.body.addEventListener('invalid', $.proxy(function (e) {
            var target = $(e.target);
            if (!target.is(':input')) {
                return;
            }
            var node = target.closest('.jstree-node');
            if (node.length && !node.hasClass('jstree-editlink-editmode')) {
                this.toggleLinkEdit(node);
            }
        }, this), true);
    };
    this.redraw_node = function(node, deep, is_callback, force_render) {
        node = parent.redraw_node.apply(this, arguments);
        if (node) {
            var nodeObj = this.get_node(node);
            if (typeof nodeObj.editlink_container === 'undefined') {
                // The container has not been drawn. Draw it and its contents.
                nodeObj.editlink_container = container.clone();
                $.post($('#nav-tree').data('link-form-url'), nodeObj.data)
                    .done(function(data) {
                        nodeObj.editlink_container.append(data);
                    });
            }
            var nodeJq = $(node);
            if (nodeObj.editlink_container.hasClass('jstree-editlink-editmode')) {
                // Node should retain the editmode class.
                nodeJq.addClass('jstree-editlink-editmode');
            }
            var anchor = nodeJq.children('.jstree-anchor');
            anchor.append(editIcon.clone());
            nodeJq.children('.jstree-anchor').after(nodeObj.editlink_container);
        }
        return node;
    };
};

/**
 * Display Plugin for jsTree
 */
$.jstree.plugins.display = function(options, parent) {
    var displayIcon = $('<i>', {
        class: 'jstree-icon jstree-displaylink',
        attr:{
            role: 'presentation',
            'title':Omeka.jsTranslate('View public page'),
            'aria-label':Omeka.jsTranslate('View public page')
        }
    });
    this.bind = function() {
        parent.bind.call(this);
        this.element.on(
            'click.jstree',
            '.jstree-displaylink',
            $.proxy(function(e) {
                var icon = $(e.currentTarget);
                var node = icon.closest('.jstree-node');
                var nodeObj = this.get_node(node);
                var nodeUrl = nodeObj.data.url;
                window.open(nodeUrl, '_blank');
            }, this)
        );
    };
    this.redraw_node = function(node, deep, is_callback, force_render) {
        node = parent.redraw_node.apply(this, arguments);
        if (node) {
            var nodeObj = this.get_node(node);
            var nodeUrl = nodeObj.data.url;
            if (nodeUrl) {
                var nodeJq = $(node);
                var anchor = nodeJq.children('.jstree-anchor');
                anchor.append(displayIcon.clone());
            }
        }
        return node;
    };
};
